/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.ducks.IECustomPayloadPacket;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.imm_ptl.core.network.PacketRedirectionClient;

public class PacketRedirection {
    private static final Logger LOGGER = LoggerFactory.getLogger(PacketRedirection.class);
    public static final ResourceLocation id_stcRedirected = new ResourceLocation("imm_ptl", "rd");
    private static final ThreadLocal<ResourceKey<Level>> serverPacketRedirection = ThreadLocal.withInitial(() -> null);
    private static final FriendlyByteBuf dummyByteBuf = new FriendlyByteBuf(Unpooled.buffer());

    public static boolean isPacketIdOfRedirection(ResourceLocation packetTypeId) {
        return packetTypeId.m_135827_().equals("imm_ptl") && packetTypeId.m_135815_().equals("rd");
    }

    public static void withForceRedirect(ServerLevel world, Runnable func) {
        PacketRedirection.withForceRedirectAndGet(world, () -> {
            func.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withForceRedirectAndGet(ServerLevel world, Supplier<T> func) {
        if (((IEWorld)world).portal_getThread() != Thread.currentThread()) {
            LOGGER.error("It's possible that a mod is trying to handle packet in networking thread instead of server thread. This is not thread safe and can cause rare bugs! (ImmPtl is just doing checking, it's not an issue of ImmPtl)", new Throwable());
        }
        ResourceKey<Level> oldRedirection = serverPacketRedirection.get();
        serverPacketRedirection.set((ResourceKey<Level>)world.m_46472_());
        try {
            T t = func.get();
            return t;
        }
        finally {
            serverPacketRedirection.set(oldRedirection);
        }
    }

    @Nullable
    public static ResourceKey<Level> getForceRedirectDimension() {
        return serverPacketRedirection.get();
    }

    public static void sendRedirectedPacket(ServerGamePacketListenerImpl serverPlayNetworkHandler, Packet<ClientGamePacketListener> packet, ResourceKey<Level> dimension) {
        if (PacketRedirection.getForceRedirectDimension() == dimension) {
            serverPlayNetworkHandler.m_9829_(packet);
        } else {
            serverPlayNetworkHandler.m_9829_(PacketRedirection.createRedirectedMessage(dimension, packet));
        }
    }

    public static void validateForceRedirecting() {
        Validate.isTrue((PacketRedirection.getForceRedirectDimension() != null ? 1 : 0) != 0);
    }

    public static void do_handleRedirectedPacket(ResourceKey<Level> dimension, Packet<ClientGamePacketListener> packet, ClientGamePacketListener handler) {
        PacketRedirectionClient.handleRedirectedPacket(dimension, packet, handler);
    }

    public static Packet<ClientGamePacketListener> createRedirectedMessage(ResourceKey<Level> dimension, Packet<ClientGamePacketListener> packet) {
        Validate.isTrue((!(packet instanceof BundleDelimiterPacket) ? 1 : 0) != 0);
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)packet;
            ArrayList<Packet<ClientGamePacketListener>> newSubPackets = new ArrayList<Packet<ClientGamePacketListener>>();
            for (Packet subPacket : bundlePacket.m_264216_()) {
                newSubPackets.add(PacketRedirection.createRedirectedMessage(dimension, (Packet<ClientGamePacketListener>)subPacket));
            }
            return new ClientboundBundlePacket(newSubPackets);
        }
        ClientboundCustomPayloadPacket result = new ClientboundCustomPayloadPacket(id_stcRedirected, dummyByteBuf);
        ((IECustomPayloadPacket)result).ip_setRedirectedDimension(dimension);
        ((IECustomPayloadPacket)result).ip_setRedirectedPacket(packet);
        return result;
    }

    public static void sendRedirectedMessage(ServerPlayer player, ResourceKey<Level> dimension, Packet packet) {
        player.f_8906_.m_9829_(PacketRedirection.createRedirectedMessage(dimension, (Packet<ClientGamePacketListener>)packet));
    }

    public static int getPacketId(Packet packet) {
        try {
            return ConnectionProtocol.PLAY.m_264521_(PacketFlow.CLIENTBOUND, packet);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Packet createPacketById(int messageType, FriendlyByteBuf buf) {
        return ConnectionProtocol.PLAY.m_178321_(PacketFlow.CLIENTBOUND, messageType, buf);
    }
}

